# Should be self-explanatory, really.
APPDIR := !Animeband

# These are used to make a !Variant file inside Fooband
FILETYPE := 020
FILETYPE_NAME := Animebnd

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := Animeband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := Animeband $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := credits.txt readme.txt changes.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Ernest Huang\"" \
	-DPORTERS="\"Antony Sidwell\"" \
    -DPDEADCHK="(p_ptr->is_dead)" \
    -DMEMTYPE=3 \
    -DFDTYPE=2 \
    -DFCLOSETYPE=2 \
    -DPATHBUILDTYPE=2 \
    -DBIGSCREEN=FALSE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA
