# Should be self-explanatory, really.
APPDIR := !EyAngband

# These are used to make a !Variant file inside Fooband
FILETYPE := 11A
FILETYPE_NAME := EyAngband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := EyAngband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := eychanges5.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Eytan Zweig\"" \
	-DPORTERS="\"Antony Sidwell\"" \
    -DPDEADCHK="(p_ptr->is_dead)" \
    -DMEMTYPE=3 \
    -DFDTYPE=3 \
    -DFCLOSETYPE=2 \
    -DPATHBUILDTYPE=3 \
	-DHAS_MY_STRCPY -DHAS_MY_STRCAT  \
	-DBIGSCREEN=TRUE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA

