# Should be self-explanatory, really.
APPDIR := !OAngband
C_STANDARD := gnu89

# These are used to make a !Variant file inside Fooband
FILETYPE := 01c
FILETYPE_NAME := OAngband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := OAngband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := O-readme.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf
                          
# Filter out maid-x11
ANG_OBJS_PROTO := $(filter-out maid-x11.o,$(ANG_OBJS_PROTO))


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Bahman Rabii\"" \
	-DPORTERS="\"Antony Sidwell\"" \
	-DPDEADCHK="(p_ptr->is_dead)" \
	-DMEMTYPE=3 \
	-DFDTYPE=1 \
	-DPATHBUILDTYPE=2 \
	-DFCLOSETYPE=2 \
	-DNEEDS_ACCESS \
	-DBIGSCREEN=TRUE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA
      