# Should be self-explanatory, really.
APPDIR := !sCthband

# These are used to make a !Variant file inside Fooband
FILETYPE := 012
FILETYPE_NAME := sCthband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := sCthangband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := readme.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf

C_STANDARD = c99

# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="MAINT_NAME" \
	-DPORTERS="\"Antony Sidwell\"" \
    -DPDEADCHK="(!alive || death)" \
    -DMEMTYPE=3 \
    -DFDTYPE=3 \
    -DFCLOSETYPE=2 \
    -DPATHBUILDTYPE=3 \
	-DBIGSCREEN=TRUE \
	-DIS_SCTH -DNEEDS_ACCESS\
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA
