# Should be self-explanatory, really.
APPDIR := !ToME
USES_LUA := 4

# These are used to make a !Variant file inside Fooband
FILETYPE := 01E
FILETYPE_NAME := ToME

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := ToME

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := changes.old changes.txt credits.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf

#### WE NEED TO (OR AT LEAST SHOULD) DELETE THE !STARTBAND DIR FROM !Fooband
setup_extra:
	@rm -r riscos/$(APPDIR)/!StartBand 

C_STANDARD = gnu89
F_CFLAGS_XTRA :=  -Isrc/lua/

# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"DarkGod & co.\"" \
	-DPORTERS="\"Antony Sidwell\"" \
	-DPDEADCHK="(!alive)" \
	-DMEMTYPE=2 \
	-DFDTYPE=1 \
    -DFCLOSETYPE=2 \
    -DPATHBUILDTYPE=2 \
	-DBIGSCREEN=TRUE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA

# Filter out q_*.o as these are #included in plot.c atm
ANG_OBJS_PROTO := $(filter-out q_%.o,$(ANG_OBJS_PROTO))

# Add package-derived files to the object list.
ANG_OBJS_PROTO := \
  $(ANG_OBJS_PROTO) \
  w_quest.o w_mnster.o w_player.o w_z_pack.o w_obj.o \
  w_util.o w_spells.o w_quest.o w_play_c.o w_dun.o

# And the hundred special cases for the packages

src/w_mnster.c: src/monster.pkg
	./src/lua/tolua -n monster -o $@ $<

src/w_player.c: src/player.pkg
	./src/lua/tolua -n player -o $@ $<

src/w_play_c.c: src/player_c.pkg
	./src/lua/tolua -n player_c -o $@ $<

src/w_z_pack.c: src/z_pack.pkg
	./src/lua/tolua -n z_pack -o $@ $<

src/w_obj.c: src/object.pkg
	./src/lua/tolua -n object -o $@ $<

src/w_util.c: src/util.pkg
	./src/lua/tolua -n util -o $@ $<

src/w_spells.c: src/spells.pkg
	./src/lua/tolua -n spells -o $@ $<

src/w_quest.c: src/quest.pkg
	./src/lua/tolua -n quest -o $@ $<

src/w_dun.c: src/dungeon.pkg
	./src/lua/tolua -n dungeon -o $@ $<
