# Should be self-explanatory, really.
APPDIR := !UnAngband

# These are used to make a !Variant file inside Fooband
FILETYPE := 120
FILETYPE_NAME := UnAband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := UnAngband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := bugs.txt changes.txt todo.txt readme.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Andrew Doull\"" \
	-DPORTERS="\"Antony Sidwell\"" \
    -DPDEADCHK="(p_ptr->is_dead)" \
    -DMEMTYPE=3 \
    -DFDTYPE=3 \
    -DFCLOSETYPE=2 \
    -DPATHBUILDTYPE=2 \
	-DHAS_MY_STRCAT -DHAS_MY_STRCPY \
	-DBIGSCREEN=FALSE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA
