# Should be self-explanatory, really.
APPDIR := !Angband
USES_LUA := 5

# These are used to make a !Variant file inside Fooband
FILETYPE := 118
FILETYPE_NAME := Angband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := Angband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := AUTHORS COPYING THANKS TODO readme.txt changes.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Robert Ruehlmann\"" \
	-DPORTERS="\"Antony Sidwell\"" \
	-DPDEADCHK="(p_ptr->is_dead)" \
	-DMEMTYPE=3 \
	-DFDTYPE=3 \
	-DPATHBUILDTYPE=3 \
	-DFCLOSETYPE=2 \
	-DHAS_MY_STRCPY -DHAS_MY_STRCAT -DHAS_MY_STRNICMP \
	-DBIGSCREEN=TRUE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA

# Rules for making our particular bunch of Lua things
# Add package-derived files to the object list.
ANG_OBJS_PROTO := $(ANG_OBJS_PROTO) $(patsubst %.pkg,%.o, $(notdir $(wildcard src/*.pkg)))

# Package files -> C files (rely on tolua)
%.c:%.pkg
	./src/lua/tolua -n $(subst .pkg,,$(subst l-,,$<)) -o $@ $<

# Vanilla's special case
src/l-monst.c:src/l-monst.pkg
	./src/lua/tolua -n monster -o src/l-monst.c src/l-monst.pkg

