# Should be self-explanatory, really.
APPDIR := !Zangband
USES_LUA := 4

# These are used to make a !Variant file inside Fooband
FILETYPE := 019
FILETYPE_NAME := Zangband

# This must correspond to the variant name in main-ros.c, and not contain
# weird characters.
VARIANT_NAME := Zangband

# This can include spaces, hyphens, etc
FULL_VARIANT_NAME := $(VARIANT_NAME) $(VARIANTVERSION)

# The files included in the source directory which we want to include
# in our RISC OS distribution too.
DOCFILES := z_faq.txt z_update.txt

# These are processed slightly on the way to being included in the
# output, to allow auto-insertion of cetain variable values 
RISCOSDOCS := !History !Read1st! !RelNotes font-acn.prf


# The evil and multitudinous definitions needed for main-ros.c
# These are all documented in main-ros.c, so look there for guidance.
MR_SETTINGS := \
	-DAUTHORS="\"Zangband dev team\"" \
	-DPORTERS="\"Antony Sidwell\"" \
	-DPDEADCHK="(p_ptr->state.is_dead)" \
	-DMEMTYPE=3 \
	-DFDTYPE=1 \
    -DPATHBUILDTYPE=1 \
    -DFCLOSETYPE=1 \
	-DBIGSCREEN=TRUE \
	-DZANGBAND_TERM_PACKAGE \
	\
	-DVARIANT="\"$(VARIANT_NAME)\"" \
	-DVERSION="\"$(VARIANTVERSION)\"" \
	-DRISCOS_VARIANT="\"$(VARIANT_NAME)\"" \
	-DICONNAME="\"$(APPDIR)\"" \
	-DUSE_DA

# Rules for making our particular bunch of Lua things
# Add package-derived files to the object list.
ANG_OBJS_PROTO := $(ANG_OBJS_PROTO) $(patsubst %.pkg,%.o, $(notdir $(wildcard src/*.pkg)))

# Package files -> C files (rely on tolua)
src/l-%.c:src/l-%.pkg
	./src/lua/tolua -n $(subst .pkg,,$(subst src/l-,,$<)) -o $@ $<

